dofile("scripts/LevelManager.lua");

LManager = LevelManager.create();

--
-- AddNewTable function prototype:
--     AddNewTable(tableID, numChairs, x, y, tableImage, markImage, color)
--

LManager:AddNewTable( 1, 4, 270, 235, "assets/images/table/ballroom", "assets/images/food/item_mark1", "B" );
LManager:AddNewTable( 2, 2, 220, 390, "assets/images/table/ballroom_2", "assets/images/food/item_mark2", "R" );
LManager:AddNewTable( 3, 2, 420, 390, "assets/images/table/ballroom_2", "assets/images/food/item_mark3", "R" );

useFloAsServer = 0;
useWineTable = 0;
numMoodBoosts = 0;
numServers = 1;
maxCoupleHappiness = 200;

-- Group 1
guest = LManager.GenGuest(male01);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = female04;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male04);
guest.matchType = male01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female04);
guest.matchType = female03;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(1, 4, 3000);

-- Group 2
guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = NOT_GUEST + aunt;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = table2;
guest.percentRequestTissue = 40;
LManager:AddGuest(guest);


LManager:SetSeatingGroup(5, 7, 22000);


-- Group 3
guest = LManager.GenGuest(female04);
guest.matchType = female01;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(8, 8, 50000);


-- Group 4
guest = LManager.GenGuest(male01);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(9, 9, 60000);

-- Group 5

guest = LManager.GenGuest(female01);
guest.matchType = table1;
LManager:AddGuest(guest);

guest = LManager.GenGuest(aunt);
guest.matchType = female01;
guest.percentRequestTissue = 30;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female03);
guest.matchType = NOT_GUEST + aunt;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(10, 12, 95000);


-- Group 6

guest = LManager.GenGuest(male04);
guest.matchType = female03;
LManager:AddGuest(guest);

guest = LManager.GenGuest(male01);
guest.matchType = NOT_GUEST + female01;
LManager:AddGuest(guest);

guest = LManager.GenGuest(female01);
guest.matchType = table2;
LManager:AddGuest(guest);

LManager:SetSeatingGroup(13, 15, 120000);


-- Okay... this adjusts with a percentage. So we can make a level easier or harder with this.
LManager:AdjustGuestTolerance(130);

--Quinn Events

LManager:SetLevelSetting ("speakerDelay", 75000); 
LManager:SetLevelSetting ("speakerChance", 40);

LManager:SetLevelSetting ("bridesmaidsDelay", 50000); 
LManager:SetLevelSetting ("bridesmaidsChance", 100);

--Reseating Requests
--LManager:AddReseatingRequest(40000);
--LManager:AddReseatingRequest(70000);
--LManager:AddReseatingRequest(90000);


-- Set up the Level Settings
LManager:SetLevelNumber(2,1);
LManager:SetLevelScores(4800, 6800);
LManager:SetLevelTime(300000);

LManager:SetMusic("assets/audio/music/Big Band 2.ogg","assets/audio/music/Uptempo 1.ogg","assets/audio/music/new_dance_2.ogg");
LManager:SetBackgroundImage("assets/images/bg_ballroom");
LManager:SetChairImage("assets/images/table/chair02");

-- Generate Game Object
gameObject = LManager:GenerateGameObject();

-- Generate Level Settings
levelSetting = LManager:GenerateLevelSettings();

-- Generate Level Dialog
dofile( "scripts/LevelDialogGenerator.lua" );
